
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1214.C - Message 1214 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1214 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1214.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:00   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:48:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:36   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:58:20   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:08   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"  

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1214 message from the ZMsgBuf.
//
void Dec1214(tMSGBUF *ZMsgBuf, tMSG1214 *Msg)
{
   GetBit    (&DGPSControlData.DGPSDisable, ZMsgBuf, 7, 0); // 1=disable
   GetBit    (&DGPSControlData.DGPSReset  , ZMsgBuf, 7, 1); // 1=reset  
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1214 message in the ZMsgBuf. 
//
void Bld1214(tMSGBUF *ZMsgBuf, tMSG1214 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                           , ZMsgBuf, 1);    // message preamble
   PutShort  (1214                             , ZMsgBuf, 2);    // message number
   PutShort  (3                                , ZMsgBuf, 3);    // message length 
   PutShort  (ANREQ                            , ZMsgBuf, 4);    // message ack/nack request
                                                               
   PutBit    (DGPSControlData.DGPSDisable , ZMsgBuf, 7, 0); // 1=disable
   PutBit    (DGPSControlData.DGPSReset   , ZMsgBuf, 7, 1); // 1=reset  
}